#include <bits/stdc++.h>

using namespace std;

vector<int> x;
vector<int> v;

long long _mergeSort(double arr[], double temp[], int left, int right);
long long _merge(double arr[], double temp[], int left, int mid, int right);

long long mergeSort(double arr[], int array_size)
{
    double temp[array_size];
    return _mergeSort(arr, temp, 0, array_size - 1);
}

long long _mergeSort(double arr[], double temp[], int left, int right)
{
    int mid;
    long long inv_count = 0;
    if (right > left)
    {
        mid = (right + left) / 2;

        inv_count += _mergeSort(arr, temp, left, mid);
        inv_count += _mergeSort(arr, temp, mid + 1, right);

        inv_count += _merge(arr, temp, left, mid + 1, right);
    }
    return inv_count;
}


long long _merge(double arr[], double temp[], int left, int mid, int right)
{
    int i;
    int j;
    int k;
    long long inv_count = 0;

    i = left;
    j = mid;
    k = left;
    while ((i <= mid - 1) && (j <= right)) {
        if (arr[i] <= arr[j]) {
            temp[k++] = arr[i++];
        }
        else {
            temp[k++] = arr[j++];

            inv_count = inv_count + (mid - i);
        }
    }

    while (i <= mid - 1)
        temp[k++] = arr[i++];

    while (j <= right)
        temp[k++] = arr[j++];

    for (i = left; i <= right; i++)
        arr[i] = temp[i];

    return inv_count;
}

int main()
{
    int n;
    long long k;

    cin >> n;
    cin >> k;

    for(int i = 0; i < n; i++)
    {
        int x_;
        int v_;

        cin >> x_;
        cin >> v_;

        x.push_back(x_);
        v.push_back(v_);
    }


    double l = 0;
    double r = 1000000000;

    double t = 0;

    while(r - l >= 0.0001)
    {
        double mid = (l + r) / 2;

        double tcomp[n];
        for(int i = 0; i < n; i++)
        {
            tcomp[i] = x[i] + (mid * v[i]);
        }

        long long invcount = 0;

        invcount = mergeSort(tcomp, n);

        if(invcount == k)
        {
            t = mid;
            r = mid;
        }
        else if(invcount > k)
        {
            r = mid;
        }
        else
        {
            l = mid;
        }
    }

    cout << t << '\n';

    return 0;
}